package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.BgmiActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ResultMatchBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.ResultModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;

public class BgmiResultAdapter extends RecyclerView.Adapter<BgmiResultAdapter.holder> {

    Context mContext;
    ArrayList<ResultModel> mlist = new ArrayList<>();

    public BgmiResultAdapter(ArrayList<ResultModel> mlist, Context mContext) {
        this.mContext = mContext;
       this.mlist =  mlist;
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.result_match,parent,false);
        return new holder(view);
    }



    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        ResultModel list = mlist.get(position);


        holder.binding.dateTxt.setText(list.getDate());
        holder.binding.timeTxt.setText(list.getTime());
        holder.binding.prizepool.setText("₹" +list.getPrizepool()+".00");
        holder.binding.perkill.setText("₹"  +list.getPerkill()+".00");
        holder.binding.entryFee.setText("₹"  +list.getEntryfee());
        holder.binding.teamtype.setText(list.getTeamtype());
        holder.binding.matchName.setText(list.getGamename() + " ( SKILL GAME ) - Match "+ list.getMatchno());
        holder.binding.matchMap.setText(list.getMap());

        checkUserJoinedStatus(holder, list);

        Picasso.get()
                .load(list.getImages())
                .placeholder(R.drawable.loading_img)
                .into(holder.binding.matchImages);


        holder.binding.matchWatchBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Intent browserIntent = new Intent(Intent.ACTION_VIEW);
                browserIntent.setData(Uri.parse(list.getVideourl()));
                mContext.startActivity(browserIntent);

            }
        });

        holder.binding.matchResultBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Intent intent = new Intent(mContext, BgmiActivity.class);
                intent.putExtra("matchid", String.valueOf(list.getId()));
                intent.putExtra("gamename", list.getGamename());
                intent.putExtra("date", list.getDate());
                intent.putExtra("time", list.getTime());
                intent.putExtra("images", list.getImages());
                intent.putExtra("matchno", list.getMatchno());
                mContext.startActivity(intent);


            }
        });



    }

    private void checkUserJoinedStatus(holder holder, ResultModel list) {

        long userId = SharedPrefManager.getInstance(mContext).getUserId();
        MyApi myApi = APIClient.getApiClient(mContext).create(MyApi.class);
        Call<CheckJoinedResponse> call = myApi.checkIfUserJoined(userId, list.getId());

        call.enqueue(new Callback<CheckJoinedResponse>() {
            @Override
            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    CheckJoinedResponse responseBody = response.body();

                    if (responseBody.isSuccess()) {
                        holder.binding.btnText.setText("View Result");

                    } else {
                        holder.binding.btnText.setText("Not Joined");
                        holder.binding.matchResultBtn.setCardBackgroundColor(ContextCompat.getColor(mContext, R.color.gray));
                    }
                } else {

                }
            }

            @Override
            public void onFailure(Call<CheckJoinedResponse> call, Throwable throwable) {
                Toast.makeText(mContext, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {
        ResultMatchBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);

            binding = ResultMatchBinding.bind(itemView);

        }
    }
}
